#include <dci.h>
#include <p30fxxxx.h>

/* DCI is enabled only for following devices */
#if defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) ||defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6014__)

/**************************************************************************
*    Function Name  : CloseDCI
*    Description    : This routine Disables the DCI module and its
*				      interrupt bits
*	 Return Value   : None
*    Parameters:    : None
*																	
***************************************************************************/

void CloseDCI(void)
{
     DCICON1bits.DCIEN = 0;     /* Disable the DCI module */
     IEC2bits.DCIIE = 0;        /* Disable the Interrupt bit in IEC Register */
     IFS2bits.DCIIF = 0;        /* Disable the Interrupt Flag bit in IFS Register */
}

#endif
